# PeriShip for WooCommerce

Contents

[PeriShip for WooCommerce
[1](#periship-for-woocommerce)](#periship-for-woocommerce)

[General overview [1](#quickstart)](#quickstart)

[Usage Notes [2](#_Toc185336774)](#_Toc185336774)

[Installation [2](#installation)](#installation)

[Plugin Configuration
[2](#plugin-configuration-shipping-zones)](#plugin-configuration-shipping-zones)

[Global Settings
[4](#plugin-configuration-global-settings)](#plugin-configuration-global-settings)

[API Server [4](#api-server)](#api-server)

[API Key [4](#api-key)](#api-key)

[Partner ID [4](#partner-id)](#partner-id)

[Debug logging [4](#debug-logging)](#debug-logging)

[Shipper street [5](#shipper-street)](#shipper-street)

[Shipper city [5](#shipper-city)](#shipper-city)

[Shipper state [6](#shipper-state)](#shipper-state)

[Shipper zip code [6](#shipper-zip-code)](#shipper-zip-code)

[Always quote residential rates
[6](#always-quote-residential-rates)](#always-quote-residential-rates)

[Show lowest rate [6](#show-lowest-rate)](#show-lowest-rate)

[Cutoff time [6](#cutoff-time)](#cutoff-time)

[Saturday delivery [7](#saturday-delivery)](#saturday-delivery)

[Blackout days [7](#blackout-days)](#blackout-days)

[Blackout dates [7](#blackout-dates)](#blackout-dates)

[Instance Settings [7](#instance-settings)](#instance-settings)

[Packer type [7](#packer-type)](#packer-type)

[Rate types [8](#rate-types)](#rate-types)

[FedEx Boxes [10](#fedex-boxes)](#fedex-boxes)

[Your Boxes [10](#your-boxes)](#your-boxes)

[Product and Product Category Configuration
[11](#product-and-product-category-configuration)](#product-and-product-category-configuration)

[ShipStation Integration
[13](#shipstation-integration)](#shipstation-integration)

[Debug Logging [14](#debug-logging-1)](#debug-logging-1)

## Quickstart

1.  Determine [compatibility](#plugin-woocommerce-support) for your
    WooCommerce Store

2.  [Install](#installation) this plugin

3.  [Configure](#plugin-configuration-shipping-zones) PeriShip for
    shipping zones where you will use PeriShip

4.  Obtain and [configure](#api-key) your PeriShip API partner ID and
    API key from PeriShip

5.  Configure [shipping](#shipper-street) address in PeriShip for your
    store

6.  Make sure all items have weights.

7.  Decide your [packing strategy](#packer-type). If you will use
    dimensions, provide dimensions on items, and define your
    [boxes](#your-boxes) to be used.

8.  If you are using ShipStation to print labels, you can take advantage
    of [automation](#shipstation-automation-rules)

## Plugin overview

The plugin uses the PeriShip API to retrieve services and rating for
products in your customer's cart. PeriShip is a 3PL logistics services
for companies that ship perishable goods through FedEx. For more
information, go to [www.periship.com](http://www.periship.com) and fill
out our Contact Form to speak to our sales team.

## Plugin operation

The plugin starts a rating request by packing your products into
configured boxes, and sending one rate request. After all rate requests
are completed, available services for all boxes are summed across each
service, and the final totals for each service are displayed to your
customer, along with FedEx commitment date and time.

## Plugin WooCommerce Support

### Checkout block support

The plugin does not support the experimental WooCommerce "checkout
block" for the checkout page. If your site is using the checkout block
in your checkout page, please edit that page and remove the checkout
block, and add the standard checkout shortcode: \[woocommerce_checkout\]

### Product editor

This plugin does not support the experimental WooCommerce product
editor. To determine if you're using the experimental product editor,
navigate to *WooCommerce-\>Settings-\>Advanced*. Click the link labeled
"*Features*" near the top of the page under the settings tabs. On the
Features page look for the setting labeled "*Try the new product editor
(Beta)*" and if it is enabled then disabled it and save the settings.

## Installation

To install the plugin login to your WordPress admin area and in the left
menu navigate to *Plugins-\>Add New Plugin*.

On that page near the top is a button labeled *Upload Plugin* (as seen
in the image below). Click the button. A form will appear below with a
button you can click to browse files on your own computer. Find the zip
file for this plugin on your computer and select it, then click the
button labeled *Install Now*.

![](./media/image1.png)

Your computer will send the zip file to the site and WordPress will then
receive it and unpack the zip file to correct location in your site's
file system. Then you will see a link you can click to activate the
plugin. Click that link to activate the plugin on your site.

## Plugin Configuration: Shipping Zones

The plugin works with Shipping Zones in WooCommerce. Please refer to
[WooCommerce shipping zones
documentation](https://woocommerce.com/document/setting-up-shipping-zones/)
for more information.

The plugin uses two groups of settings to control plugin operation:
*Global settings* and *Instance settings*. Global settings apply to all
instances of the shipping method in all shipping zones. Instance
settings are settings that only apply to a specific instance of the
shipping method added to any particular shipping zone in your site.

After configuring the global settings add the PeriShip shipping method
to any shipping zones that you use on your site. When editing a specific
zone you will see a list of shipping methods that you have added to that
zone. If you added PeriShip to the zone then to the right of that
shipping method you will see a link labeled *Edit* (as seen in the image
below where a United States zone has already been added and PeriShip
added to that zone). Click that to see instance settings for that
particular instance of the PeriShip shipping method.

All of the global and instance settings are outlined below.

## Plugin Configuration: Global Settings

2.  ![](./media/image2.png)To configure the plugin's settings, in the
    left menu navigate to *WooCommerce-\>Settings-\>Shipping* tab.

    Click the link labeled *PeriShip* below the tabs on the page (as
    seen in the image below).. These are the global settings that apply
    to all instances of PeriShip across all your shipping zones. The
    settings are outlined below.

### API Server 

Select whether to use test mode or production mode. Production mode
should be selected.

### API Key 

Enter your API key given to you by PeriShip. If you don't have one,
reach out to us through the PeriShip customer portal.

### Partner ID 

Enter your Partner ID for authenticating to the API.

### Debug logging 

Debug output can be displayed on the screen at checkout and/or logged to
a log file named \"periship\" and located at
*WooCommerce-\>Status-\>Logs* tab.

![](./media/image3.png)

Debug information provided will be the same regardless of selected debug
mode. In the log file, it is formatted as plain text. When shown on the
checkout page screen, it appears in colored boxes, usually with white
text and a blue background, depending on your site's WordPress theme.

Debug output on the screen at checkout will be visible to all people
visiting the checkout page. **Don't use this mode unless you are
testing**.

Logging to file is visible in the Wordpress Admin area. A new log file
is created each day. When a log file exceeds 5mb in size, a second file
for that day (and so on) is created. WooCommerce automatically deletes
log files older than 30 days by default.

Logging can help you determine how the plugin is packing items and
formatting the rate request, and how PeriShip is responding to any
particular rate request. It can also assist us with troubleshooting.

See the Debug Logging section below for information about debug
information.

### Shipper street 

The street address from where your shipments will originate.

### Shipper city 

The city from where your shipments will originate.

### Shipper state 

The state from where your shipments will originate.

### Shipper zip code 

The zip code from where your shipments will originate.

### Always quote residential rates 

When enabled, this setting will always quote at PeriShip at residential
rates, regardless of the address type the shopper selects. When disabled
the \"Address type\" fields on the checkout page will be used for the
shopper to choose their address type (commercial or residential). The
purpose of this feature is to prevent customers from getting a cheaper
rate by misrepresenting their address type.

### Show lowest rate 

Enable if you only want to show the lowest available service rate at
checkout.

### Blackout days 

Configure any days of the week where you will not ship packages. This is
used to help determine the shipment date in rate requests sent to the
PeriShip API.

### Blackout dates 

Enter specific blackout dates or ranges (one per line) for which will
not ship packages. This is used to help determine the shipment date in
rate requests sent to the PeriShip API.

**Format the dates correctly as shown in the formatted examples below**:

Date format: YYYY/mm/dd.

Date example: 2025/12/23 -- 2025/12/26

### Cutoff time 

Your cutoff time for shipping on any given day. Enter the time in
24-hour format (ex: 15:00).

This setting is used to determine the shipment date sent to the API when
sending rate requests.

The ship date for the order is determined as follows:

- If the current local time in your site is before the cutoff time, then
  today's date will be used if it is not a blackout day.

- Otherwise, the next available shipment date will be used taking into
  consideration any blackout days and blackout dates.

To check the time in your site navigate in your WordPress admin area to
*Settings-\>General*. Then scroll down to the section for the timezone
setting. There you will find the local time for your site, which is
based on your site's timezone setting. If necessary change the timezone
to suit your needs.

![](./media/image4.png)

### Saturday delivery 

Enable if you will offer FedEx Saturday deliveries. FedEx Saturday
Delivery is an extra service for express shipments (Priority Overnight
or FedEx 2 Day). There is an extra charge for FedEx Saturday Delivery
(please refer to the PeriShip Client Manual)

## Instance Settings

### Packer type

The plugin packs all products in the cart into boxes. This setting
determines which boxes will be used for packing. The packed boxes will
then be used to get shipping rates.

- *Packed based on weights only* - This packing method will only use
  weights when getting rates from PeriShip. The shipment will be split
  into 1 or more boxes of 60 pounds each.

- *Pack into FedEx boxes -* When selected, only FedEx enabled boxes will
  be used for packing items into boxes.

- *Pack into your boxes* - When selected, you can configure your own
  custom boxes. Note that you can add boxes but not enable them for use
  yet. Any of your boxes that are enabled will be used.

- *Pack into FedEx boxes and your boxes -* When this setting is selected
  then all enabled boxes will be used for getting shipping rates.

### Rate types

This setting allows you select which FedEx services you want to offer
your shoppers. Enable each rate type that you want to offer. See the
image below for an example of the rate type settings.

![](./media/image5.png)

The code column indicates how the service is defined at our API, and
cannot be changed.

The Name column indicates how the service will be shown in the cart and
order, and also how it would be exported to other platforms like
ShipStation.

Each rate type allows you define excluded shipping classes and max days
in transit. You can also add one or two markup amounts to the rates.

- *Excluded shipping classes* -- when defined, if any products in the
  cart has a shipping class that matches an excluded class for a service
  type then that service type will not be offered to the shopper at
  checkout. Shipping classes can be configured at the product or
  category level.

- *Max days in transit --* Each service rate type in the API response
  returns a delivery commitment date. If you enter a number into this
  field and the number of days between the shipment day and commitment
  delivery date exceeds the number you entered then the service rate
  will not be offered to the shopper.

- *Markup 1 and Markup 2* -- These 2 fields allow you to add markup
  amounts to each service rate type. Markup 1 is added to the rate cost
  first, then Markup 2 is added to the result. The markups can be a flat
  amount or a percentage. For a flat amount enter the amount. For a
  percent enter the amount followed by a percent symbol (for example
  5%).

### FedEx Boxes

This setting section appears when you select a packer type of *Pack into
FedEx boxes* or *Pack into FedEx boxes and your boxes.*

Check the checkbox next to each box type to enable the use of that box
when packing items to get shipping rates.

![](./media/image6.png)

### Your Boxes

This setting section appears when you select a packer type of *Pack into
your boxes* or *Pack into FedEx boxes and your boxes.*

![](./media/image7.png)

You can click the *Add Box* button to add as many boxes as you need.

For each box that you add you must set a name, length, width, height,
box weight, max weight.

For the box name enter any name that makes sense to you.

- Dimensions - refers to the actual outer dimensions of the box.

- *Box weight* - refers to the weight of the box itself.

- *Max weight* - refers to the maximum weight allowed for the total
  weight of all items packed into the box.

## Product and Product Category Configuration

- When editing a product you will find 3 new settings located in the
  Product Data section's Shipping subsection.

> ![](./media/image8.png)

- Include declared value -- enable this setting to include the product's
  price as part of the declared value when getting shipping rates from
  the API. If exported to ShipStation, the entire cart (minus shipping
  cost) will be used for declared value calculation.

- Dry ice -- if the product requires that it be packed with dry ice,
  then enter the amount of dry ice required in kilograms (KG). This data
  will be sent to PeriShip when getting shipping rates from the API. For
  ShipStation, it will be exported, but you will need to provide the dry
  ice weight before creating the label.

- Signature -- If the product requires a signature upon delivery then
  select the signature type (adult, direct, indirect, no signature -- in
  order of precedence). When defined this data will be sent to PeriShip
  when getting shipping rates from the API using the highest precedence
  of all products in the cart.

<!-- -->

- Product categories now include an additional setting for *Shipping
  class*. Products in WooCommerce already have a shipping class -- if
  these conflict, Product will take precedence.

> ![](./media/image9.png)

Conflicts between product and category are resolved with product
settings taking precedence if defined.

In this way you can simplify your product configurations. For example if
you have a product named "Seafood" for products that always ships with
0.5kg of dry ice then you can configure the dry amount into the category
and not have to add it to each product individually.

## ShipStation Integration

This plugin automatically integrates into ShipStation if you use the
WooCommerce Shipstation plugin.

When orders are imported into ShipStation, any special services required
for the order (dry ice, signature requirement, etc.) in ShipStations's
"custom field 3" and also send the boxes used to pack the items during
rate requests on your site in "custom field 2".

The special services, if any exist for the order, will be abbreviated to
look something like this: "dv, resi". The possible abbreviations are as
follows:

- dv -- declared value

- resi -- residential delivery

- dry ice -- dry ice required

- sig_aud, sig_dir, or sig_ind -- signature type for this order. This
  will be the strictest signature requirement of all products in the
  order: Adult signature, Direct signature, or Indirect signature -- in
  that order of precedence.

The box information will look something like: "2pc -- Fedex Large Box,
1pc -- My medium box" (where "My medium box" is the name you assign to
any of your own custom boxes added into the plugin's main settings.
ShipStation cannot use automation rules to split shipments, so we
recommend reviewing this field when shipping out to split the order and
assign packaging.

## Shipstation Automation Rules

If you would like special services such as Dry Ice, Signature
Confirmation, and Saturday Delivery to be automatically set on an order
based upon the order rated in the cart, you can define automation rules.
Below is a screenshot of all of the related automation rules setup :

![](./media/image10.png)

### ShipStation 3^rd^ Party Billing Setup

![](./media/image11.png)

This rule is necessary for all PeriShip customers that will be importing
orders into ShipStation.

### ShipStation Dry Ice setup

![](./media/image12.png)

Please note the amount of dry ice is not exported, so you will need to
provide that in the Shipstation order (or modify the rule to include a
specific amount of dry ice and change as needed)

### ShipStation Signature Confirmation setup (Direct,Adult, Indirect)

![](./media/image13.png)

You can setup 3 automation rules (1 for each signature type: Direct,
Indirect, Adult), as needed.

### Shipstation Declared Value

![](./media/image14.png)

If you would like to use FedEx Declared Value, setup this automation
rule. Note that the entire charged value of the cart (minus the
shipping) will be submitted for the amount by ShipStation, and that
value cannot be controlled.

## Debug Logging

When debug logging is enabled the plugin outputs information for each
package rate request.

The debug output will show the request data sent to PeriShip and the
response sent back from PeriShip.

You can review that information to determine what the plugin is doing in
terms of packing boxes and sending rate requests as well as what
PeriShip is responding with.

Note that the request and response data will be repeated on the screen
for each package rate request. See the partial screenshots below for
examples.

![](./media/image15.png)

![](./media/image16.png)
